//Radius for each hexagon. Smaller = more hexagons
#define R .075
//Difference between neighbouring hexagons.
// #define OFFSET 2.
//Strength of the falloff in the corners
// #define FALLOFF 0.4
//Strength of Fisheye effect on each facet
// #define FISH 1.0


#define SQRT3 1.732050807
#define PI 3.141592653


vec2 hexCenter(vec2 id, float odd)
{
	return vec2(
		SQRT3 * R * (id.x +.5*odd),
		1.5 * id.y * R
		);
}
vec4 FUNCNAME(vec2 tc) 
{
	vec4 c = INPUT(tc);
    int alpha = PREFIX(alpha);
    float Fall_off = float(PREFIX(Fall_off))/100.0;  
    float Offset = float(PREFIX(Offset))/10.0;  
    float Fish = float(PREFIX(Fish))/10.0;  
   
   //UV coordinates [1,2]
	vec2 uv = tc;
	uv.xy += 1.0;
	vec2 grid;

	//Estimate hex coordinate
	grid.y = floor(uv.y / (1.5*R));
	float odd = mod(grid.y, 2.0);
	grid.x = floor(uv.x / (SQRT3 * R) - odd*.5);

	//Find possible centers of hexagons
	vec2 h1 = hexCenter(grid, odd);
	vec2 h2 = hexCenter(grid + vec2(1.0,0.0), odd);
	vec2 h3 = hexCenter(grid + vec2(odd, 1.0), 1.0-odd);

	//Find closest center
	float d1 = dot(h1-uv, h1-uv);
	float d2 = dot(h2-uv, h2-uv);
	float d3 = dot(h3-uv, h3-uv);
    
	if (d2 < d1)
	{
		d1 = d2;
		h1 = h2;
	}
	if (d3 < d1)
	{
		d1 = d3;
		h1 = h3;
	}
	
    //Hexagon UV
	vec2 uv2 = uv - h1;
    
    //Set Hexagon offset
	uv = (uv.xy - 1.0) + uv2 * Offset;

    //Per Facet Fisheye effect (optional)
	vec2 coords = (uv2 - 0.5*R) * 2.0;
	vec2 fisheye;
	fisheye.x = (1.0 - coords.y * coords.y) * Fish * (coords.x);
	fisheye.y = (1.0 - coords.x * coords.x) * Fish * (coords.y);
	uv -= fisheye*R;


    //Retrieve texture colour
    vec4 fragColor = INPUT(uv);

    //Redude corners (optional)
	fragColor = max(vec4(0.0), fragColor - length(2.0*uv-1.0)*Fall_off);
    return mix( fragColor, c, 1.0 - float(alpha)/100.0 );
   
   
}